#!/usr/bin/env php
<?php
// cron/check_alerts.php - Check alerts for all users

require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../includes/Database.php';
require_once __DIR__ . '/../includes/AlertChecker.php';

$db = Database::getInstance();
$pdo = $db->getConnection();

echo "[" . date('Y-m-d H:i:s') . "] Starting alert checks...\n";

// Get all users
$stmt = $pdo->query("SELECT id FROM users");
$users = $stmt->fetchAll();

foreach ($users as $user) {
    echo "Checking alerts for user {$user['id']}...\n";
    
    try {
        $checker = new AlertChecker($user['id']);
        $checker->checkAllAlerts();
        $checker->checkOrderBookAlerts();
        $checker->checkLiquidationAlerts();
    } catch (Exception $e) {
        echo "Error for user {$user['id']}: " . $e->getMessage() . "\n";
    }
}

echo "Alert checks completed!\n";